<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenafiler" 
	xmlns:p1="http://www.sec.gov/edgar/common">
	
	<xsl:template name="Item2">
		<table class="filingInformation" id="registrantIdentification" >
			<tr>
				<td class="label">
					Name of Broker-dealer
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:registrantIdentification/p:brokerDealerName" />
					</div>
				</td>
			</tr>
		</table>
		
		<h4><em>Address of Principal Place of Business (Do not use P.O. Box No.)</em></h4>
		
		<table>
			<tr>
				<td class="label"> Address 1</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:registrantIdentification/p:businessAddress/p1:street1" />
					</div>
				</td>
			</tr>
			<xsl:if test="count(p:registrantIdentification/p:businessAddress/p1:street2) &gt; 0">
				<tr>
					<td class="label">Address 2</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:registrantIdentification/p:businessAddress/p1:street2" />
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">City</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:registrantIdentification/p:businessAddress/p1:city" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">State/Country</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="p:registrantIdentification/p:businessAddress/p1:stateOrCountry" />
						</xsl:call-template>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">Mailing Zip/ Portal Code</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:registrantIdentification/p:businessAddress/p1:zipCode" />
					</div>
				</td>
			</tr>
		</table>
		
		<h4><em>Name and Telephone Number of Person to Contact in Regard to this Report</em></h4>
		
		<table>
			<tr>
				<td class="label">Name</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:registrantIdentification/p:contactPersonName" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">Telephone Number</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:registrantIdentification/p:contactPersonPhoneNumber" />
					</div>				
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>